/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.zb;

import com.gprinter.zb.CompressedBitmapOutputStreamA;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CompressedBitmapOutputStreamZpl
extends CompressedBitmapOutputStreamA {
    private byte previousByteWritten = 0;
    private int previousByteWrittenRepeatCount = 0;
    private static final int[] charMap = new int[]{380, 360, 340, 320, 300, 280, 260, 240, 220, 200, 180, 160, 140, 120, 100, 80, 60, 40, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    private static final char[] charVal = new char[]{'y', 'x', 'w', 'v', 'u', 't', 's', 'r', 'q', 'p', 'o', 'n', 'm', 'l', 'k', 'j', 'i', 'h', 'g', 'Y', 'X', 'W', 'V', 'U', 'T', 'S', 'R', 'Q', 'P', 'O', 'N', 'M', 'L', 'K', 'J', 'I', 'H', 'G'};

    public CompressedBitmapOutputStreamZpl(OutputStream var1) {
        this.outputStream = var1;
        this.internalEncodedBuffer = new ByteArrayOutputStream();
    }

    @Override
    public void write(byte[] var1) throws IOException {
        for (int var2 = 0; var2 < var1.length; ++var2) {
            byte[] var3 = this.extractNibblesFromByte(var1[var2]);
            this.writeNibblesToStream(var3);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.previousByteWrittenRepeatCount > 0) {
            this.sendBufferedDataToPrinter();
            this.previousByteWrittenRepeatCount = 0;
        }
        super.flush();
    }

    private void writeNibblesToStream(byte[] var1) throws IOException {
        for (int var2 = 0; var2 < var1.length; ++var2) {
            this.writeNibbleToStream(var1[var2]);
        }
    }

    private void writeNibbleToStream(byte var1) throws IOException {
        if (this.previousByteWrittenRepeatCount == 0) {
            this.previousByteWritten = var1;
            ++this.previousByteWrittenRepeatCount;
        } else if (this.previousByteWritten == var1) {
            ++this.previousByteWrittenRepeatCount;
        } else {
            this.sendBufferedDataToPrinter();
            this.previousByteWritten = var1;
            this.previousByteWrittenRepeatCount = 1;
        }
    }

    private void sendBufferedDataToPrinter() throws IOException {
        try {
            this.computeAndOutput();
        }
        catch (Exception var2) {
            throw new IOException(var2.getMessage());
        }
    }

    private void computeAndOutput() throws IOException, Exception {
        if (this.previousByteWrittenRepeatCount > 1) {
            int var3;
            int var1 = this.previousByteWrittenRepeatCount / 400;
            int var2 = this.previousByteWrittenRepeatCount % 400;
            for (var3 = 0; var3 < var1; ++var3) {
                this.bufferAndWrite('z');
            }
            for (var3 = 0; var3 < charMap.length; ++var3) {
                if (var2 < charMap[var3]) continue;
                this.bufferAndWrite(charVal[var3]);
                var2 -= charMap[var3];
            }
        }
        this.bufferAndWrite(Integer.toHexString(this.previousByteWritten & 0xF).toUpperCase().charAt(0));
    }

    private byte[] extractNibblesFromByte(byte var1) {
        byte[] var2 = new byte[]{(byte)(~var1 >> 4 & 0xF), (byte)(~var1 & 0xF)};
        return var2;
    }
}

